/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jclass.beans.JCTabEditor;
import jclass.bwt.JCOutliner;
import jclass.bwt.JCOutlinerFolderNode;
import jclass.bwt.JCOutlinerNode;
import jclass.util.JCVector;

public class AxisSelector
extends JCTabEditor
implements ActionListener {
    protected JCOutliner outliner;
    protected JCVector objects;

    public AxisSelector() {
        this.setLayout(new BorderLayout());
        this.outliner = new JCOutliner();
        this.add((Component)this.outliner, "Center");
        this.outliner.setScrollbarDisplay(0);
        this.outliner.setPreferredSize(200, 100);
        this.outliner.setVisibleRows(2);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.add((Component)panel, "South");
        Button button = new Button("Choose");
        panel.add(button);
        button.addActionListener(this);
        button = new Button("Select None");
        panel.add(button);
        button.addActionListener(this);
    }

    public void setAxes(JCVector jCVector) {
        this.objects = jCVector;
        if (this.objects == null) {
            return;
        }
        String string = null;
        string = this.target == null ? new String("No Axis Selected") : this.target.toString();
        JCOutlinerFolderNode jCOutlinerFolderNode = new JCOutlinerFolderNode(string);
        this.outliner.setRootNode(jCOutlinerFolderNode);
        int n = 0;
        while (n < this.objects.size()) {
            Object e = this.objects.elementAt(n);
            if (e != null) {
                JCOutlinerNode jCOutlinerNode = new JCOutlinerNode(e.toString());
                jCOutlinerFolderNode.addNode(jCOutlinerNode);
            }
            ++n;
        }
    }

    public void setValue(Object object) {
        super.setValue(object);
        this.setAxes(this.objects);
        this.outliner.folderChanged(this.outliner.getRootNode());
        this.outliner.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JCOutlinerNode jCOutlinerNode = this.outliner.getSelectedNode();
        int n = this.objects.indexOf(jCOutlinerNode);
        if (n > this.objects.size()) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        Object object = this.target;
        if (actionEvent.getActionCommand().equals("Choose")) {
            this.setValue(this.objects.elementAt(n));
        } else if (actionEvent.getActionCommand().equals("Select None")) {
            this.setValue(null);
        }
        this.setAxes(this.objects);
        this.support.firePropertyChange(null, object, this.target);
    }
}

